<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */
 $p="45";
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> <?php twentytwentyone_the_html_classes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<link rel="icon" href="<?php echo get_template_directory_uri();?>/img/fav-icon.png" type="image/x-icon" />
<title><?php the_title();?></title>
<?php wp_head(); ?>
</head>
   <div class="fix-icon">
      <div id="fix-icon" class="fix-icon-item">
         <a href="tel:<?php the_field('footer_whatsapp_number',$p);?>" target="blank"><img src="<?php echo get_template_directory_uri();?>/img/phone-icon.png" alt=""></a>
      </div>
   </div>
   <div class="fix-icon-whataap">
      <div id="fix-icon-whataap" class="fix-icon-whataap-item">
         <a href="https://api.whatsapp.com/send?phone=<?php the_field('footer_whatsapp_number',$p);?>&amp;text=Hello,I Want to know more about Justfix Automotive Mobile Mechanic. &source=&amp;data=" target="blank"><img src="<?php echo get_template_directory_uri();?>/img/whatsapp.svg" alt=""></a>
      </div>
   </div>
   <body>
      <!--================Header Area Start =================-->
      <header class="main-header">
         <div class="header_top">
            <div class="container">
               <div class="header_top_inner">
                  <div class="row">
                     <div class="col-md-7 col-sm-7">
                        <div class="contact-info">
                           <a href="tel:<?php the_field('header_number',$p);?>"><i class="fa fa-phone-alt"></i><span><?php the_field('header_number',$p);?></span>
                           </a>
                           <a href="mailto:<?php the_field('header_email',$p);?>"><i
                              class="fa fa-envelope"></i><span><?php the_field('header_email',$p);?></span>
                           </a>
                        </div>
                     </div>
                     <div class="col-md-5 col-sm-2">
                        <div class="searchsocial_grid">
                           <span class="search-dropdown">
                              <a href="#" class="serach_icon"><i class="fa fa-search"></i></a>
                              <ul class="header-search">
                                 <li>
                                    <form action="#" method="get" class="header-searchform">
                                       <div class="input-group">
                                          <input type="search" class="form-control" placeholder="Search for">
                                          <span class="input-group-addon">
                                          <button type="submit"><i class="icon icon-Search"></i></button>
                                          </span>
                                       </div>
                                    </form>
                                 </li>
                              </ul>
                           </span>
                           <ul class="header_social">
                              <li><a href="<?php the_field('facebook_link',$p);?>"><i class="fab fa-facebook-f"></i></a></li>
                              <li><a href="<?php the_field('twitter_link',$p);?>"><i class="fab fa-twitter"></i></a></li>
                              <li><a href="<?php the_field('google_plus_link',$p);?>"><i class="fab fa-google-plus-g"></i></a></li>
                              <li><a href="<?php the_field('linkedin_link',$p);?>"><i class="fab fa-linkedin-in"></i></a></li>
                           </ul>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="header-menu">
            <div class="container">
               <nav class="navbar navbar-expand-md affix" data-spy="affix" data-offset-top="197">
                  <a class="navbar-brand" href="<?php echo esc_url(home_url('/'));?>"><img src="<?php echo get_template_directory_uri();?>/img/logo.webp" alt="logo"></a>
                  <button class="navbar-toggler" type="button" data-toggle="collapse"
                     data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                     aria-expanded="false" aria-label="Toggle navigation">
                  <span class="navbar-toggler-icon"></span>
                  </button>
                  <div class="collapse navbar-collapse" id="navbarSupportedContent">
                     
					 <ul class="navbar-nav">
						<ul class="navbar-nav">
                        <li><a class="nav-link" href="<?php echo esc_url(home_url('/'));?>">Home</a></li>
                        <li><a class="nav-link" href="<?php echo esc_url(home_url('/'));?>about-us/">About Us</a></li>
                        <li class="dropdown">
                           <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown2" role="button"
                              data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                           SERVICE
                           <i class="fa fa-angle-down"></i>
                           </a>
                           <ul class="dropdown-menu">
                              <?php
			     $defaults = array(
			 	'theme_location'  => 'primary',
			 	'menu'            => 'Header Service Menu',
			 	'container'       => false,
			 	'container_class' => '',
			 	'container_id'    => '',
			 	'menu_class'      => '',
			 	'menu_id'         => '',
			 	'echo'            => false,
			 	'fallback_cb'     => false,
			 	'before'          => '',
			 	'after'           => '',
			 	'link_before'     => '',
			 	'link_after'      => '',
			 	'depth'           => 0,
   			    'add_li_class'  => ''
			);
			 $menu = wp_nav_menu($defaults);
             echo preg_replace(array(
            '#^<ul[^>]*>#',
            '#</ul>$#'
            ), '', $menu);
		  ?>
                           </ul>
                        </li>
                        <li><a class="nav-link" href="<?php echo esc_url(home_url('/'));?>blog/">Blog</a></li>
                        <li><a class="nav-link" href="<?php echo esc_url(home_url('/'));?>testimonial/">Testimonials</a></li>
                        <li><a class="nav-link" href="<?php echo esc_url(home_url('/'));?>warranty-policy/">Warranty Poilcy</a></li>
                     </ul>	
					 </ul>
                     <a href="<?php echo esc_url(home_url('/'));?>contact-us/" class="theme-btn-2 btn-md"><strong class="d-block">CONTACT US</strong></a>
                  </div>
               </nav>
            </div>
         </div>
      </header>
      <!-- Start mobile memu -->
      <header class="d-lg-none">
         <div class="logo-port"><img src="<?php echo get_template_directory_uri();?>/img/logo.webp" alt="logo-mobile"></div>
      </header>
      <ul class="mobile_menu ">
         <li><a href="<?php echo esc_url(home_url('/'));?>">Home</a></li>
         <li><a href="<?php echo esc_url(home_url('/'));?>about-us/">about Us</a></li>
         <li>
            <a href="#">Service</a>
            <ul class="submenu">
               <?php
			     $defaults = array(
			 	'theme_location'  => 'primary',
			 	'menu'            => 'Header Service Menu',
			 	'container'       => false,
			 	'container_class' => '',
			 	'container_id'    => '',
			 	'menu_class'      => '',
			 	'menu_id'         => '',
			 	'echo'            => false,
			 	'fallback_cb'     => false,
			 	'before'          => '',
			 	'after'           => '',
			 	'link_before'     => '',
			 	'link_after'      => '',
			 	'depth'           => 0,
   			    'add_li_class'  => ''
			);
			 $menu = wp_nav_menu($defaults);
             echo preg_replace(array(
            '#^<ul[^>]*>#',
            '#</ul>$#'
            ), '', $menu);
		  ?>
               <li>
            </ul>
         </li>
         <li> <a href="<?php echo esc_url(home_url('/'));?>blog/">Blog</a> </li>
         <li> <a href="<?php echo esc_url(home_url('/'));?>testimonial/">Testimonials</a> </li>
         <li> <a href="<?php echo esc_url(home_url('/'));?>warranty-policy/">Warranty Poilcy</a> </li>
         <li> <a href="<?php echo esc_url(home_url('/'));?>contact-us/">Contact Us</a> </li>
      </ul>
      <!-- End mobile Menu -->
      <!--================Header Area End =================-->
