<?php
/*
 * Template Name: Blog Detail
 * Template Post Type: post
*/ 
get_header();
error_reporting(0);
global $wp_query;
$post_id = $wp_query->post->ID;//post id
$parent_id= wp_get_post_parent_id(); // get parent Id of detail page
$parentunder_id=wp_get_post_parent_id($parent_id);
$parentop_id =wp_get_post_parent_id($parentunder_id);
$background_image = get_field('background_image');
$feat_image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
$imgID  = get_post_thumbnail_id($post_id);
$imgAlt = get_post_meta($imgID,'_wp_attachment_image_alt', true);
?>
<section class="banner_area banner_one">
   <div class="container">
      <div class="content-align">
         <div class="content-center">
            <div class="banner_content">
               <h3><?php the_title();?></h3>
            </div>
            <div class="banner_link">
               <div class="abnner_link_inner">
                  <a class="active" href="<?php echo esc_url(home_url('/'));?>">Home</a>
                  <a href="#0"><?php the_title();?></a>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>
<div class="container">
   <div class="row">
      <div class="col-lg-12 col-sm-12">
         <div class="curve-bg d-none d-sm-block"><img src="<?php echo get_template_directory_uri();?>/img/resource/curve-bg-2.png" alt=""></div>
      </div>
   </div>
</div>
<section class="blog-page single_blog_details">
   <div class="container">
      <div class="row main_blog_inner">
         <div class="col-md-8">
            <div class="main_blog_items">
               <div class="main_blogpost_item">
                  <div class="blog_image">
                     <img src="<?php echo $feat_image[0];?>" alt="<?php echo $imgAlt;?>">
                     <div class="date">
					 <?php 
					    $d = get_the_date( 'd-M-y' ); 
					    $exp =explode('-',$d);
					 ?>
                        <h5><?php echo $exp[0];?><span><br/><?php echo $exp[1];?></span></h5>
                     </div>
                  </div>
                  <div class="main_blog_text">
                     <a href="#">
                        <h2><?php the_field('blog_detail_page_heading');?></h2>
                     </a>
                     <div class="blog_author_area">
					<a href="#"><i class="fa fa-user"></i>By :  <span><?php $author_id=$post->post_author;
					ucfirst(the_author_meta( 'user_nicename' , $author_id )); 
					?></span></a>
                        <a href="#"><i class="far fa-calendar-alt"></i><span> <?php echo get_the_date( 'd-M-y' ); ?></span></a>
                     </div>
                     <p><?php the_content();?></p>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-md-4">
            <div class="blog_sidebar_area">
               <aside class="mrgn_widget search_widget pd-all-20 bg-color-light-grey">
                  <div class="input-group">
                     <input type="text" class="form-control" placeholder="Enter Search Keywords">
                     <span class="input-group-btn">
                     <button class="btn btn-default theme_color" type="button"><i class="icon icon-Search"></i></button>
                     </span>
                  </div>
               </aside>
               <aside class="mrgn_widget widget pd-all-20 bg-color-light-grey">
                  <div class="blog_widget_title">
                     <h3 class="widget-title theme-color">Recent Blog Posts</h3>
                  </div>
                  <div class="related-post">
					 <ul class="popular-post">
						<?php
						$latest_post=new WP_Query( array('post_type' =>'post','posts_per_page'=>5,'order'=>'DESC', 'post__not_in' => array($post_id)));
						while($latest_post->have_posts()){
						$latest_post->the_post();
						$url = get_permalink();
						$feat_image1 = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
						$imgID  = get_post_thumbnail_id($post_id);
						$imgAlt = get_post_meta($imgID,'_wp_attachment_image_alt', true);
						?>
                        <li class="clearfix">
                           <div class="thumb">
                              <img src="<?php echo $feat_image1[0];?>" alt="<?php echo $imgAlt;?>" width="100">
                           </div>
                           <div class="related-post-content-wrap">
                              <h5><a href="<?php echo $url;?>"><?php the_title();?></a></h5>
                              <span><i class="far fa-calendar-alt"></i> <?php echo get_the_date( 'M-d-y' ); ?></span>
                           </div>
                        </li>
						 <?php } wp_reset_query();?>
                     </ul>
                  </div>
               </aside>
            </div>
         </div>
      </div>
   </div>
</section>
<div class="search-wrap">
   <div class="search-container mfp-inline-holder">
      <div class="content_cover">
         <div class="search_area" id="test-search">
            <div class="search_box_inner">
               <h3>Search</h3>
               <div class="input-group">
                  <input type="text" class="form-control" placeholder="Enter search keywords">
                  <span class="input-group-btn">
                  <button class="btn btn-default" type="button"><i class="icon icon-Search"></i></button>
                  </span>
               </div>
            </div>
            <span  class="serach-close">×</span>
         </div>
      </div>
   </div>
</div>
<?php
get_footer();